#pragma once
#include <string>

namespace nlc {

/**
	* @brief CAN bus baudrates
	* 
	* - std::string
*/
struct CanBaudRate {
	const std::string BAUD_RATE_1000K = "1000k";
	const std::string BAUD_RATE_800K = "800k";
	const std::string BAUD_RATE_500K = "500k";
	const std::string BAUD_RATE_250K = "250k";
	const std::string BAUD_RATE_125K = "125k";
	const std::string BAUD_RATE_100K = "100k";
	const std::string BAUD_RATE_50K = "50k";
	const std::string BAUD_RATE_20K = "20k";
	const std::string BAUD_RATE_10K = "10k";
	const std::string BAUD_RATE_5K = "5k";
};

/**
	* @brief IXXAT adapter bus number
	*
	* - std::string
*/
struct IxxatAdapterBusNumber {
	const std::string BUS_NUMBER_0_DEFAULT = "0";
	const std::string BUS_NUMBER_1 = "1";
	const std::string BUS_NUMBER_2 = "2";
	const std::string BUS_NUMBER_3 = "3";
};

/**
	* @brief IXXAT adapter configuration options
*/
struct Ixxat {
	const std::string ADAPTER_BUS_NUMBER_OPTIONS_NAME = "ixxat adapter bus number";
	const IxxatAdapterBusNumber adapterBusNumber = IxxatAdapterBusNumber();
};

/**
	* @brief CAN bus configuration options
*/
struct CanBus {
	const std::string BAUD_RATE_OPTIONS_NAME = "can adapter baud rate";
	const CanBaudRate baudRate = CanBaudRate();
	const Ixxat ixxat = Ixxat();
};

/**
	* @brief Serial communication parity options
	*
	* - std::string
*/
struct SerialParity {
	const std::string NONE = "none";
	const std::string ODD = "odd";
	const std::string EVEN = "even";
	const std::string MARK = "mark";
	const std::string SPACE = "space";
};

/**
	* @brief Serial communication baudrate
	*
	* - std::string
*/
struct SerialBaudRate {
	const std::string BAUD_RATE_7200 = "7200";
	const std::string BAUD_RATE_9600 = "9600";
	const std::string BAUD_RATE_14400 = "14400";
	const std::string BAUD_RATE_19200 = "19200";
	const std::string BAUD_RATE_38400 = "38400";
	const std::string BAUD_RATE_56000 = "56000";
	const std::string BAUD_RATE_57600 = "57600";
	const std::string BAUD_RATE_115200 = "115200";
	const std::string BAUD_RATE_128000 = "128000";
	const std::string BAUD_RATE_256000 = "256000";
};

/**
	* @brief Serial communication configuration options
*/
struct Serial {
	const std::string BAUD_RATE_OPTIONS_NAME = "serial baud rate";
	const SerialBaudRate baudRate = SerialBaudRate();
	const std::string PARITY_OPTIONS_NAME = "serial parity";
	const SerialParity parity = SerialParity();
};

/**
 * @brief RESTful communication configuration options
 */
struct RESTfulBus {
	const std::string CONNECT_TIMEOUT_OPTION_NAME = "RESTful Connect Timeout";
	const unsigned long DEFAULT_CONNECT_TIMEOUT = 200; /* msec */
	const std::string REQUEST_TIMEOUT_OPTION_NAME = "RESTful Request Timeout";
	const unsigned long DEFAULT_REQUEST_TIMEOUT = 200; /* msec */
	const std::string RESPONSE_TIMEOUT_OPTION_NAME = "RESTful Response Timeout";
	const unsigned long DEFAULT_RESPONSE_TIMEOUT = 750; /* msec */
};

/**
	* @brief Default configuration options class
*/
struct BusHwOptionsDefault {
	const CanBus canBus = CanBus();
	const Serial serial = Serial();
	const RESTfulBus restfulBus = RESTfulBus();
};

const BusHwOptionsDefault busHwOptionsDefaults;
} // namespace nlc
